
clear all
clc
% SEEK project data based on DFM
[data_fci_dfm]=xlsread('FCIs_DFM_D1_201307.xls','FCIs_dfm','B2:L398'); %Jan 1980-Okt 2012
[data_fcib_dfm]=xlsread('FCIs_DFM_D1_201307.xls','BCIs','N2:X398'); %Jan 1980-Okt 2012
[data_ip_dfm]=xlsread('IP_201305.xls','logIP-1','O20:Y416'); %Jan 1981-Aug 2012
%-------------------------------------------------------------------------
% determine data/country used
fci=data_fci_dfm(1:end,2);
bci=data_fcib_dfm(1:end,2);
ip=data_ip_dfm(1:end,5);

ip=ip(1:end);
fci=fci(1:end);
bci=bci(1:end);


y=[ip,fci]; trans=[fci, fci];

translag_common=1;
laglen=3;
pmax=laglen;
dep=y(laglen+1:end,:);
ylag1=mlag(y,laglen);     ylag1=ylag1(laglen+1:end,:);
ylag2=ylag1; ylag3=ylag1; ylag4=ylag1;
transvar=lag(fci,translag_common);
transvar=transvar(laglen+1:end,:);

%--------------------------------------------------------------------------
% --> ESTIMATION


% starting value search and estimation

[startval_de,max_likeli_de]=sv_ho_de_vector_sur_21_nu(dep,ylag1,ylag2,ylag3,ylag4,transvar);

startval=startval_de';

regs_1.eq{:,1}=ylag1; %eq1 linear
regs_1.eq{:,2}=ylag2; %eq1 nonlinear
regs_2.eq{:,1}=ylag3; %eq2 linear
regs_2.eq{:,2}=ylag4; %eq1 nonlinear

[results_VSTAR] = vstar_est_ML_nu_const(dep,regs_1.eq,regs_2.eq,transvar,startval');

